/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.Cover;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverType;
import com.refinedmods.refinedstorage.item.CoverItem;
import com.refinedmods.refinedstorage.render.model.BakedModelCableCover;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class BakedModelCover
extends BakedModelCableCover {
    private static final LoadingCache<CacheKey, List<BakedQuad>> CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(CacheKey key) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            BakedModelCableCover.addCover(quads, new Cover(key.stack, key.type), Direction.NORTH, key.side, new Random(), null, null, true);
            return quads;
        }
    });
    private ItemStack stack;
    private CoverType type;

    public BakedModelCover(ItemStack stack, CoverType type) {
        super(null);
        this.stack = stack;
        this.type = type;
    }

    @Override
    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        if (this.stack.m_41619_()) {
            return Collections.emptyList();
        }
        CacheKey key = new CacheKey(state, CoverItem.getItem(this.stack), side, this.type);
        return (List)CACHE.getUnchecked((Object)key);
    }

    @Override
    public ItemOverrides m_7343_() {
        return new ItemOverrides(){

            public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int p) {
                return new BakedModelCover(stack, BakedModelCover.this.type);
            }
        };
    }

    @Override
    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack poseStack) {
        Transformation transform = (Transformation)RenderUtils.getDefaultBlockTransforms().get((Object)cameraTransformType);
        if (transform != null) {
            transform.push(poseStack);
        }
        return this;
    }

    @Override
    public boolean m_7541_() {
        return true;
    }

    @Override
    public boolean m_7539_() {
        return true;
    }

    @Override
    public boolean m_7521_() {
        return false;
    }

    @Override
    public TextureAtlasSprite m_6160_() {
        return null;
    }

    public boolean useAmbientOcclusion(BlockState state) {
        return true;
    }

    @Override
    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    @Override
    public boolean m_7547_() {
        return true;
    }

    private class CacheKey {
        private BlockState state;
        private ItemStack stack;
        private Direction side;
        private CoverType type;

        CacheKey(BlockState state, ItemStack stack, Direction side, CoverType type) {
            this.state = state;
            this.stack = stack;
            this.side = side;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return cacheKey.type == this.type && cacheKey.stack.m_41720_() == this.stack.m_41720_() && cacheKey.side == this.side && Objects.equals(cacheKey.state, this.state);
        }

        public int hashCode() {
            int result = this.stack.m_41720_().hashCode();
            result = 31 * result + (this.side != null ? this.side.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }
}

